/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.sonarlint.eclipse.ui.internal.SonarLintUiPlugin;

public final class SonarLintImages {
    private static final URL BASE_URL = SonarLintUiPlugin.getDefault().getBundle().getEntry("/icons/");
    public static final ImageDescriptor SONARWIZBAN_IMG = SonarLintImages.createImageDescriptor("sonarqube-48x200.png");
    public static final ImageDescriptor IMG_WIZBAN_NEW_SERVER = SonarLintImages.createImageDescriptor("new_server_wiz.png");
    public static final ImageDescriptor SONARLINT_CONSOLE_IMG_DESC = SonarLintImages.createImageDescriptor("sonarlint-16x16.png");
    public static final ImageDescriptor UPDATE_IMG = SonarLintImages.createImageDescriptor("update.gif");
    public static final ImageDescriptor WIZ_NEW_SERVER = SonarLintImages.createImageDescriptor("wiz_new_server.gif");
    public static final ImageDescriptor SQ_LABEL_DECORATOR = SonarLintImages.createImageDescriptor("onde-label-decorator.gif");
    public static final Image SERVER_ICON_IMG = SonarLintImages.createImage("onde-sonar-16.png");
    public static final Image IMG_ISSUE = SonarLintImages.createImage("issue_annotation.png");
    public static final Image IMG_SEVERITY_BLOCKER = SonarLintImages.createImage("severity/blocker.png");
    public static final Image IMG_SEVERITY_CRITICAL = SonarLintImages.createImage("severity/critical.png");
    public static final Image IMG_SEVERITY_MAJOR = SonarLintImages.createImage("severity/major.png");
    public static final Image IMG_SEVERITY_MINOR = SonarLintImages.createImage("severity/minor.png");
    public static final Image IMG_SEVERITY_INFO = SonarLintImages.createImage("severity/info.png");
    public static final ImageDescriptor DEBUG = SonarLintImages.createImageDescriptor("debug.gif");
    public static final ImageDescriptor SHOW_CONSOLE = SonarLintImages.createImageDescriptor("showConsole.gif");

    private static URL getUrl(String key) throws MalformedURLException {
        return new URL(BASE_URL, key);
    }

    private static Image createImage(String key) {
        SonarLintImages.createImageDescriptor(key);
        ImageRegistry imageRegistry = SonarLintImages.getImageRegistry();
        return imageRegistry != null ? imageRegistry.get(key) : null;
    }

    private static ImageDescriptor createImageDescriptor(String key) {
        ImageRegistry imageRegistry = SonarLintImages.getImageRegistry();
        if (imageRegistry != null) {
            ImageDescriptor imageDescriptor = imageRegistry.getDescriptor(key);
            if (imageDescriptor == null) {
                try {
                    imageDescriptor = ImageDescriptor.createFromURL((URL)SonarLintImages.getUrl(key));
                }
                catch (MalformedURLException malformedURLException) {
                    imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
                }
                imageRegistry.put(key, imageDescriptor);
            }
            return imageDescriptor;
        }
        return null;
    }

    private static ImageRegistry getImageRegistry() {
        if (PlatformUI.isWorkbenchRunning()) {
            return SonarLintUiPlugin.getDefault().getImageRegistry();
        }
        return null;
    }

    private SonarLintImages() {
    }
}

